-- --------------------------------------------------------
-- Host:                         52.74.129.178
-- Server version:               5.5.60-MariaDB - MariaDB Server
-- Server OS:                    Linux
-- HeidiSQL Version:             9.4.0.5125
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


-- Dumping database structure for rms_db
CREATE DATABASE IF NOT EXISTS `rms_db` /*!40100 DEFAULT CHARACTER SET latin1 */;
USE `rms_db`;

-- Dumping structure for table rms_db.allowed_company
CREATE TABLE IF NOT EXISTS `allowed_company` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_change_request` tinyint(1) NOT NULL,
  `create_change_request_template` tinyint(1) NOT NULL,
  `view_all_change_request` tinyint(1) NOT NULL,
  `created_at` datetime(6) NOT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `company_pivot_id` varchar(255) NOT NULL,
  `group_pivots_id` varchar(255) NOT NULL,
  `id_number_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `allowed_company_company_pivot_id_35c7dec7_fk_companies_code` (`company_pivot_id`),
  KEY `allowed_company_group_pivots_id_3b2e331c_fk_departments_code` (`group_pivots_id`),
  KEY `allowed_company_id_number_id_7c5c7fc8_fk_auth_user_code` (`id_number_id`),
  CONSTRAINT `allowed_company_id_number_id_7c5c7fc8_fk_auth_user_code` FOREIGN KEY (`id_number_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `allowed_company_company_pivot_id_35c7dec7_fk_companies_code` FOREIGN KEY (`company_pivot_id`) REFERENCES `companies` (`code`),
  CONSTRAINT `allowed_company_group_pivots_id_3b2e331c_fk_departments_code` FOREIGN KEY (`group_pivots_id`) REFERENCES `departments` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.allowed_company: ~0 rows (approximately)
DELETE FROM `allowed_company`;
/*!40000 ALTER TABLE `allowed_company` DISABLE KEYS */;
/*!40000 ALTER TABLE `allowed_company` ENABLE KEYS */;

-- Dumping structure for table rms_db.applications
CREATE TABLE IF NOT EXISTS `applications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.applications: ~3 rows (approximately)
DELETE FROM `applications`;
/*!40000 ALTER TABLE `applications` DISABLE KEYS */;
INSERT INTO `applications` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`) VALUES
	(1, '2019-09-23 12:43:33.754098', 'superuser', '2019-09-23 12:43:33.754098', 'superuser', 'APP-20190923-0000001', 'Resource Management System'),
	(2, '2019-09-23 12:43:40.512905', 'superuser', '2019-09-23 12:43:40.512905', 'superuser', 'APP-20190923-0000002', 'Change Request Management System'),
	(3, '2019-09-23 12:43:55.957076', 'superuser', '2019-09-23 12:43:55.957076', 'superuser', 'APP-20190923-0000003', 'Asset Management System');
/*!40000 ALTER TABLE `applications` ENABLE KEYS */;

-- Dumping structure for table rms_db.attachments
CREATE TABLE IF NOT EXISTS `attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.attachments: ~0 rows (approximately)
DELETE FROM `attachments`;
/*!40000 ALTER TABLE `attachments` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachments` ENABLE KEYS */;

-- Dumping structure for table rms_db.authtoken_token
CREATE TABLE IF NOT EXISTS `authtoken_token` (
  `key` varchar(40) NOT NULL,
  `created` datetime(6) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`key`),
  UNIQUE KEY `user_id` (`user_id`),
  CONSTRAINT `authtoken_token_user_id_35299eff_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.authtoken_token: ~1 rows (approximately)
DELETE FROM `authtoken_token`;
/*!40000 ALTER TABLE `authtoken_token` DISABLE KEYS */;
INSERT INTO `authtoken_token` (`key`, `created`, `user_id`) VALUES
	('e4f665c846c7b6b88a3af198c8d99f5c07322f86', '2019-09-23 16:10:51.904439', 1);
/*!40000 ALTER TABLE `authtoken_token` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_access_token
CREATE TABLE IF NOT EXISTS `auth_access_token` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(255) NOT NULL,
  `token` longtext NOT NULL,
  `passcode` varchar(255) NOT NULL,
  `timeout` int(11) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `auth_access_token_user_id_c480a680_fk_auth_user_code` (`user_id`),
  CONSTRAINT `auth_access_token_user_id_c480a680_fk_auth_user_code` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_access_token: ~0 rows (approximately)
DELETE FROM `auth_access_token`;
/*!40000 ALTER TABLE `auth_access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_access_token` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_group
CREATE TABLE IF NOT EXISTS `auth_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_group: ~0 rows (approximately)
DELETE FROM `auth_group`;
/*!40000 ALTER TABLE `auth_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_group` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_group_permissions
CREATE TABLE IF NOT EXISTS `auth_group_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_group_permissions_group_id_permission_id_0cd325b0_uniq` (`group_id`,`permission_id`),
  KEY `auth_group_permissio_permission_id_84c5c92e_fk_auth_perm` (`permission_id`),
  CONSTRAINT `auth_group_permissio_permission_id_84c5c92e_fk_auth_perm` FOREIGN KEY (`permission_id`) REFERENCES `auth_permission` (`id`),
  CONSTRAINT `auth_group_permissions_group_id_b120cbf9_fk_auth_group_id` FOREIGN KEY (`group_id`) REFERENCES `auth_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_group_permissions: ~0 rows (approximately)
DELETE FROM `auth_group_permissions`;
/*!40000 ALTER TABLE `auth_group_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_group_permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_permission
CREATE TABLE IF NOT EXISTS `auth_permission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `content_type_id` int(11) NOT NULL,
  `codename` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_permission_content_type_id_codename_01ab375a_uniq` (`content_type_id`,`codename`),
  CONSTRAINT `auth_permission_content_type_id_2f476e4b_fk_django_co` FOREIGN KEY (`content_type_id`) REFERENCES `django_content_type` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=137 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_permission: ~136 rows (approximately)
DELETE FROM `auth_permission`;
/*!40000 ALTER TABLE `auth_permission` DISABLE KEYS */;
INSERT INTO `auth_permission` (`id`, `name`, `content_type_id`, `codename`) VALUES
	(1, 'Can add log entry', 1, 'add_logentry'),
	(2, 'Can change log entry', 1, 'change_logentry'),
	(3, 'Can delete log entry', 1, 'delete_logentry'),
	(4, 'Can view log entry', 1, 'view_logentry'),
	(5, 'Can add permission', 2, 'add_permission'),
	(6, 'Can change permission', 2, 'change_permission'),
	(7, 'Can delete permission', 2, 'delete_permission'),
	(8, 'Can view permission', 2, 'view_permission'),
	(9, 'Can add group', 3, 'add_group'),
	(10, 'Can change group', 3, 'change_group'),
	(11, 'Can delete group', 3, 'delete_group'),
	(12, 'Can view group', 3, 'view_group'),
	(13, 'Can add content type', 4, 'add_contenttype'),
	(14, 'Can change content type', 4, 'change_contenttype'),
	(15, 'Can delete content type', 4, 'delete_contenttype'),
	(16, 'Can view content type', 4, 'view_contenttype'),
	(17, 'Can add session', 5, 'add_session'),
	(18, 'Can change session', 5, 'change_session'),
	(19, 'Can delete session', 5, 'delete_session'),
	(20, 'Can view session', 5, 'view_session'),
	(21, 'Can add Token', 6, 'add_token'),
	(22, 'Can change Token', 6, 'change_token'),
	(23, 'Can delete Token', 6, 'delete_token'),
	(24, 'Can view Token', 6, 'view_token'),
	(25, 'Can add user', 7, 'add_user'),
	(26, 'Can change user', 7, 'change_user'),
	(27, 'Can delete user', 7, 'delete_user'),
	(28, 'Can view user', 7, 'view_user'),
	(29, 'Can add application', 8, 'add_application'),
	(30, 'Can change application', 8, 'change_application'),
	(31, 'Can delete application', 8, 'delete_application'),
	(32, 'Can view application', 8, 'view_application'),
	(33, 'Can add attachment', 9, 'add_attachment'),
	(34, 'Can change attachment', 9, 'change_attachment'),
	(35, 'Can delete attachment', 9, 'delete_attachment'),
	(36, 'Can view attachment', 9, 'view_attachment'),
	(37, 'Can add change request form header', 10, 'add_changerequestformheader'),
	(38, 'Can change change request form header', 10, 'change_changerequestformheader'),
	(39, 'Can delete change request form header', 10, 'delete_changerequestformheader'),
	(40, 'Can view change request form header', 10, 'view_changerequestformheader'),
	(41, 'Can add change request history', 11, 'add_changerequesthistory'),
	(42, 'Can change change request history', 11, 'change_changerequesthistory'),
	(43, 'Can delete change request history', 11, 'delete_changerequesthistory'),
	(44, 'Can view change request history', 11, 'view_changerequesthistory'),
	(45, 'Can add change request template header', 12, 'add_changerequesttemplateheader'),
	(46, 'Can change change request template header', 12, 'change_changerequesttemplateheader'),
	(47, 'Can delete change request template header', 12, 'delete_changerequesttemplateheader'),
	(48, 'Can view change request template header', 12, 'view_changerequesttemplateheader'),
	(49, 'Can add company', 13, 'add_company'),
	(50, 'Can change company', 13, 'change_company'),
	(51, 'Can delete company', 13, 'delete_company'),
	(52, 'Can view company', 13, 'view_company'),
	(53, 'Can add email logs', 14, 'add_emaillogs'),
	(54, 'Can change email logs', 14, 'change_emaillogs'),
	(55, 'Can delete email logs', 14, 'delete_emaillogs'),
	(56, 'Can view email logs', 14, 'view_emaillogs'),
	(57, 'Can add entity log', 15, 'add_entitylog'),
	(58, 'Can change entity log', 15, 'change_entitylog'),
	(59, 'Can delete entity log', 15, 'delete_entitylog'),
	(60, 'Can view entity log', 15, 'view_entitylog'),
	(61, 'Can add password reset', 16, 'add_passwordreset'),
	(62, 'Can change password reset', 16, 'change_passwordreset'),
	(63, 'Can delete password reset', 16, 'delete_passwordreset'),
	(64, 'Can view password reset', 16, 'view_passwordreset'),
	(65, 'Can add permission', 17, 'add_permission'),
	(66, 'Can change permission', 17, 'change_permission'),
	(67, 'Can delete permission', 17, 'delete_permission'),
	(68, 'Can view permission', 17, 'view_permission'),
	(69, 'Can add role', 18, 'add_role'),
	(70, 'Can change role', 18, 'change_role'),
	(71, 'Can delete role', 18, 'delete_role'),
	(72, 'Can view role', 18, 'view_role'),
	(73, 'Can add status', 19, 'add_status'),
	(74, 'Can change status', 19, 'change_status'),
	(75, 'Can delete status', 19, 'delete_status'),
	(76, 'Can view status', 19, 'view_status'),
	(77, 'Can add user image', 20, 'add_userimage'),
	(78, 'Can change user image', 20, 'change_userimage'),
	(79, 'Can delete user image', 20, 'delete_userimage'),
	(80, 'Can view user image', 20, 'view_userimage'),
	(81, 'Can add role permission', 21, 'add_rolepermission'),
	(82, 'Can change role permission', 21, 'change_rolepermission'),
	(83, 'Can delete role permission', 21, 'delete_rolepermission'),
	(84, 'Can view role permission', 21, 'view_rolepermission'),
	(85, 'Can add notification', 22, 'add_notification'),
	(86, 'Can change notification', 22, 'change_notification'),
	(87, 'Can delete notification', 22, 'delete_notification'),
	(88, 'Can view notification', 22, 'view_notification'),
	(89, 'Can add module', 23, 'add_module'),
	(90, 'Can change module', 23, 'change_module'),
	(91, 'Can delete module', 23, 'delete_module'),
	(92, 'Can view module', 23, 'view_module'),
	(93, 'Can add department', 24, 'add_department'),
	(94, 'Can change department', 24, 'change_department'),
	(95, 'Can delete department', 24, 'delete_department'),
	(96, 'Can view department', 24, 'view_department'),
	(97, 'Can add change request template stake holders', 25, 'add_changerequesttemplatestakeholders'),
	(98, 'Can change change request template stake holders', 25, 'change_changerequesttemplatestakeholders'),
	(99, 'Can delete change request template stake holders', 25, 'delete_changerequesttemplatestakeholders'),
	(100, 'Can view change request template stake holders', 25, 'view_changerequesttemplatestakeholders'),
	(101, 'Can add change request template details', 26, 'add_changerequesttemplatedetails'),
	(102, 'Can change change request template details', 26, 'change_changerequesttemplatedetails'),
	(103, 'Can delete change request template details', 26, 'delete_changerequesttemplatedetails'),
	(104, 'Can view change request template details', 26, 'view_changerequesttemplatedetails'),
	(105, 'Can add change request template attachments', 27, 'add_changerequesttemplateattachments'),
	(106, 'Can change change request template attachments', 27, 'change_changerequesttemplateattachments'),
	(107, 'Can delete change request template attachments', 27, 'delete_changerequesttemplateattachments'),
	(108, 'Can view change request template attachments', 27, 'view_changerequesttemplateattachments'),
	(109, 'Can add change request template approvers', 28, 'add_changerequesttemplateapprovers'),
	(110, 'Can change change request template approvers', 28, 'change_changerequesttemplateapprovers'),
	(111, 'Can delete change request template approvers', 28, 'delete_changerequesttemplateapprovers'),
	(112, 'Can view change request template approvers', 28, 'view_changerequesttemplateapprovers'),
	(113, 'Can add change request form stake holders', 29, 'add_changerequestformstakeholders'),
	(114, 'Can change change request form stake holders', 29, 'change_changerequestformstakeholders'),
	(115, 'Can delete change request form stake holders', 29, 'delete_changerequestformstakeholders'),
	(116, 'Can view change request form stake holders', 29, 'view_changerequestformstakeholders'),
	(117, 'Can add change request form details', 30, 'add_changerequestformdetails'),
	(118, 'Can change change request form details', 30, 'change_changerequestformdetails'),
	(119, 'Can delete change request form details', 30, 'delete_changerequestformdetails'),
	(120, 'Can view change request form details', 30, 'view_changerequestformdetails'),
	(121, 'Can add change request form attachments', 31, 'add_changerequestformattachments'),
	(122, 'Can change change request form attachments', 31, 'change_changerequestformattachments'),
	(123, 'Can delete change request form attachments', 31, 'delete_changerequestformattachments'),
	(124, 'Can view change request form attachments', 31, 'view_changerequestformattachments'),
	(125, 'Can add change request form approvers', 32, 'add_changerequestformapprovers'),
	(126, 'Can change change request form approvers', 32, 'change_changerequestformapprovers'),
	(127, 'Can delete change request form approvers', 32, 'delete_changerequestformapprovers'),
	(128, 'Can view change request form approvers', 32, 'view_changerequestformapprovers'),
	(129, 'Can add auth token', 33, 'add_authtoken'),
	(130, 'Can change auth token', 33, 'change_authtoken'),
	(131, 'Can delete auth token', 33, 'delete_authtoken'),
	(132, 'Can view auth token', 33, 'view_authtoken'),
	(133, 'Can add allowed company', 34, 'add_allowedcompany'),
	(134, 'Can change allowed company', 34, 'change_allowedcompany'),
	(135, 'Can delete allowed company', 34, 'delete_allowedcompany'),
	(136, 'Can view allowed company', 34, 'view_allowedcompany');
/*!40000 ALTER TABLE `auth_permission` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user
CREATE TABLE IF NOT EXISTS `auth_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `last_login` datetime(6) DEFAULT NULL,
  `is_superuser` tinyint(1) NOT NULL,
  `first_name` varchar(30) NOT NULL,
  `last_name` varchar(150) NOT NULL,
  `is_staff` tinyint(1) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `date_joined` datetime(6) NOT NULL,
  `user_type` varchar(100) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) DEFAULT NULL,
  `contact_no` varchar(255) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `default_app_id` varchar(255) DEFAULT NULL,
  `department_id` varchar(255) DEFAULT NULL,
  `doa_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `username` (`username`),
  KEY `auth_user_default_app_id_410ec732_fk_applications_code` (`default_app_id`),
  KEY `auth_user_department_id_ff5fa3db_fk_departments_code` (`department_id`),
  KEY `auth_user_doa_id_5076b369_fk_auth_user_code` (`doa_id`),
  CONSTRAINT `auth_user_doa_id_5076b369_fk_auth_user_code` FOREIGN KEY (`doa_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `auth_user_default_app_id_410ec732_fk_applications_code` FOREIGN KEY (`default_app_id`) REFERENCES `applications` (`code`),
  CONSTRAINT `auth_user_department_id_ff5fa3db_fk_departments_code` FOREIGN KEY (`department_id`) REFERENCES `departments` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_user: ~1 rows (approximately)
DELETE FROM `auth_user`;
/*!40000 ALTER TABLE `auth_user` DISABLE KEYS */;
INSERT INTO `auth_user` (`id`, `last_login`, `is_superuser`, `first_name`, `last_name`, `is_staff`, `is_active`, `date_joined`, `user_type`, `code`, `name`, `username`, `password`, `contact_no`, `email`, `default_app_id`, `department_id`, `doa_id`) VALUES
	(1, '2019-09-23 15:50:43.923500', 1, '', '', 1, 1, '2019-09-23 12:42:37.938304', 'SU', 'USER-20190923-0000001', '', 'superuser', 'pbkdf2_sha256$150000$iRXbWni4Raha$8DJ3wThPtpO9yupcR/cZZQjSQz5DTTLrj2SWClkcqDc=', NULL, 'red@tirsolutions.com', 'APP-20190923-0000001', 'DEPARTMENT-20190923-0000001', NULL),
	(9, NULL, 0, '', '', 0, 1, '2019-09-23 15:55:13.512369', 'DUA', 'USER-20190923-0000009', 'test', 'test', 'pbkdf2_sha256$150000$2TF6IEeZC2FJ$sYfzKL2W+9b25R0Is2zxJWgxkT3paN1uAf3xE4ZSz1g=', '132', 'test@mail.com', 'APP-20190923-0000002', 'DEPARTMENT-20190923-0000001', NULL),
	(10, NULL, 0, '', '', 0, 1, '2019-09-23 16:06:31.459234', 'DUA', 'USER-20190923-0000010', 'qwe', 'qwe', 'pbkdf2_sha256$150000$SaaV0bSTBQmX$uimdUKd1jdSm2D1rjUlG3fbX1onTh6/T+RPeB3y73WI=', '123', 'qwe@qwe.com', 'APP-20190923-0000002', 'DEPARTMENT-20190923-0000001', NULL);
/*!40000 ALTER TABLE `auth_user` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_application
CREATE TABLE IF NOT EXISTS `auth_user_application` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `application_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_user_application_user_id_application_id_4d89d44a_uniq` (`user_id`,`application_id`),
  KEY `auth_user_application_application_id_5c17d611_fk_applications_id` (`application_id`),
  CONSTRAINT `auth_user_application_application_id_5c17d611_fk_applications_id` FOREIGN KEY (`application_id`) REFERENCES `applications` (`id`),
  CONSTRAINT `auth_user_application_user_id_7b07e391_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_user_application: ~3 rows (approximately)
DELETE FROM `auth_user_application`;
/*!40000 ALTER TABLE `auth_user_application` DISABLE KEYS */;
INSERT INTO `auth_user_application` (`id`, `user_id`, `application_id`) VALUES
	(1, 1, 1),
	(2, 1, 2),
	(3, 1, 3),
	(15, 9, 1),
	(16, 9, 2),
	(17, 10, 1),
	(18, 10, 2);
/*!40000 ALTER TABLE `auth_user_application` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_groups
CREATE TABLE IF NOT EXISTS `auth_user_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_user_groups_user_id_group_id_94350c0c_uniq` (`user_id`,`group_id`),
  KEY `auth_user_groups_group_id_97559544_fk_auth_group_id` (`group_id`),
  CONSTRAINT `auth_user_groups_group_id_97559544_fk_auth_group_id` FOREIGN KEY (`group_id`) REFERENCES `auth_group` (`id`),
  CONSTRAINT `auth_user_groups_user_id_6a12ed8b_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_user_groups: ~0 rows (approximately)
DELETE FROM `auth_user_groups`;
/*!40000 ALTER TABLE `auth_user_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user_groups` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_images
CREATE TABLE IF NOT EXISTS `auth_user_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `is_primary` tinyint(1) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `auth_user_images_user_id_7c29985d_fk_auth_user_code` (`user_id`),
  CONSTRAINT `auth_user_images_user_id_7c29985d_fk_auth_user_code` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_user_images: ~0 rows (approximately)
DELETE FROM `auth_user_images`;
/*!40000 ALTER TABLE `auth_user_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user_images` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_user_permissions
CREATE TABLE IF NOT EXISTS `auth_user_user_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_user_user_permissions_user_id_permission_id_14a6b632_uniq` (`user_id`,`permission_id`),
  KEY `auth_user_user_permi_permission_id_1fbb5f2c_fk_auth_perm` (`permission_id`),
  CONSTRAINT `auth_user_user_permi_permission_id_1fbb5f2c_fk_auth_perm` FOREIGN KEY (`permission_id`) REFERENCES `auth_permission` (`id`),
  CONSTRAINT `auth_user_user_permissions_user_id_a95ead1b_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_user_user_permissions: ~0 rows (approximately)
DELETE FROM `auth_user_user_permissions`;
/*!40000 ALTER TABLE `auth_user_user_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user_user_permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_approvers
CREATE TABLE IF NOT EXISTS `change_request_form_approvers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` varchar(50) DEFAULT NULL,
  `delegation` varchar(50) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `action` varchar(50) DEFAULT NULL,
  `date_sent` datetime(6) DEFAULT NULL,
  `form_code_id` varchar(255) NOT NULL,
  `tmp_approver_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `action_date` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_form__form_code_id_5dfe5c56_fk_change_re` (`form_code_id`),
  KEY `change_request_form__tmp_approver_id_fff34e6d_fk_change_re` (`tmp_approver_id`),
  KEY `change_request_form_approvers_user_id_3a71dffe_fk_auth_user_code` (`user_id`),
  CONSTRAINT `change_request_form_approvers_user_id_3a71dffe_fk_auth_user_code` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_form__form_code_id_5dfe5c56_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`),
  CONSTRAINT `change_request_form__tmp_approver_id_fff34e6d_fk_change_re` FOREIGN KEY (`tmp_approver_id`) REFERENCES `change_request_template_approvers` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_form_approvers: ~0 rows (approximately)
DELETE FROM `change_request_form_approvers`;
/*!40000 ALTER TABLE `change_request_form_approvers` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_form_approvers` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_attachments
CREATE TABLE IF NOT EXISTS `change_request_form_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_type` varchar(255) NOT NULL,
  `attachment_name` varchar(255) NOT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `file_upload` varchar(100) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `form_code_id` varchar(255) NOT NULL,
  `tmp_attach_id` varchar(255) DEFAULT NULL,
  `uploaded_by_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_form__form_code_id_6f991ff9_fk_change_re` (`form_code_id`),
  KEY `change_request_form__tmp_attach_id_14c2eae7_fk_change_re` (`tmp_attach_id`),
  KEY `change_request_form__uploaded_by_id_3187c462_fk_auth_user` (`uploaded_by_id`),
  CONSTRAINT `change_request_form__uploaded_by_id_3187c462_fk_auth_user` FOREIGN KEY (`uploaded_by_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_form__form_code_id_6f991ff9_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`),
  CONSTRAINT `change_request_form__tmp_attach_id_14c2eae7_fk_change_re` FOREIGN KEY (`tmp_attach_id`) REFERENCES `change_request_template_attachments` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_form_attachments: ~0 rows (approximately)
DELETE FROM `change_request_form_attachments`;
/*!40000 ALTER TABLE `change_request_form_attachments` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_form_attachments` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_details
CREATE TABLE IF NOT EXISTS `change_request_form_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_idx` longtext NOT NULL,
  `field_ref` longtext NOT NULL,
  `field_val` longtext NOT NULL,
  `field_props` longtext NOT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `form_code_id` varchar(255) NOT NULL,
  `tmp_detail_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_form__form_code_id_b66d4e40_fk_change_re` (`form_code_id`),
  KEY `change_request_form__tmp_detail_id_315fbb6d_fk_change_re` (`tmp_detail_id`),
  CONSTRAINT `change_request_form__tmp_detail_id_315fbb6d_fk_change_re` FOREIGN KEY (`tmp_detail_id`) REFERENCES `change_request_template_details` (`code`),
  CONSTRAINT `change_request_form__form_code_id_b66d4e40_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_form_details: ~0 rows (approximately)
DELETE FROM `change_request_form_details`;
/*!40000 ALTER TABLE `change_request_form_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_form_details` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_headers
CREATE TABLE IF NOT EXISTS `change_request_form_headers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `requested_to_template_name` varchar(255) NOT NULL,
  `requested_to_objective` varchar(255) DEFAULT NULL,
  `requested_to_priority` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `form_code` varchar(255) NOT NULL,
  `cancel_date` datetime(6) DEFAULT NULL,
  `status` varchar(50) NOT NULL,
  `company_desc` varchar(255) DEFAULT NULL,
  `department_desc` varchar(255) DEFAULT NULL,
  `requested_desc` varchar(255) DEFAULT NULL,
  `old_form_code` varchar(255) DEFAULT NULL,
  `requested_to_template_id` varchar(255) NOT NULL,
  `requested_to_target_date` datetime(6) DEFAULT NULL,
  `requested_by_department_id` varchar(255) NOT NULL,
  `requested_by_user_id` varchar(255) NOT NULL,
  `requested_to_company_id` varchar(255) NOT NULL,
  `requested_to_department_id` varchar(255) NOT NULL,
  `requested_to_user_id` varchar(255) NOT NULL,
  `template_no_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_code` (`form_code`),
  KEY `change_request_form__requested_by_departm_af6aa045_fk_departmen` (`requested_by_department_id`),
  KEY `change_request_form__requested_by_user_id_3287070c_fk_auth_user` (`requested_by_user_id`),
  KEY `change_request_form__requested_to_company_33982877_fk_companies` (`requested_to_company_id`),
  KEY `change_request_form__requested_to_departm_c5d594cd_fk_departmen` (`requested_to_department_id`),
  KEY `change_request_form__requested_to_user_id_11252c8d_fk_auth_user` (`requested_to_user_id`),
  KEY `change_request_form__template_no_id_20abd55c_fk_change_re` (`template_no_id`),
  CONSTRAINT `change_request_form__template_no_id_20abd55c_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`),
  CONSTRAINT `change_request_form__requested_by_departm_af6aa045_fk_departmen` FOREIGN KEY (`requested_by_department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `change_request_form__requested_by_user_id_3287070c_fk_auth_user` FOREIGN KEY (`requested_by_user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_form__requested_to_company_33982877_fk_companies` FOREIGN KEY (`requested_to_company_id`) REFERENCES `companies` (`code`),
  CONSTRAINT `change_request_form__requested_to_departm_c5d594cd_fk_departmen` FOREIGN KEY (`requested_to_department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `change_request_form__requested_to_user_id_11252c8d_fk_auth_user` FOREIGN KEY (`requested_to_user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_form_headers: ~0 rows (approximately)
DELETE FROM `change_request_form_headers`;
/*!40000 ALTER TABLE `change_request_form_headers` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_form_headers` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_stakeholders
CREATE TABLE IF NOT EXISTS `change_request_form_stakeholders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `delegation` varchar(255) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `date_added` datetime(6) DEFAULT NULL,
  `form_code_id` varchar(255) NOT NULL,
  `tmp_stake_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_form__form_code_id_350d3c3d_fk_change_re` (`form_code_id`),
  KEY `change_request_form__tmp_stake_id_fe1f7139_fk_change_re` (`tmp_stake_id`),
  KEY `change_request_form__user_id_378bdf3e_fk_auth_user` (`user_id`),
  CONSTRAINT `change_request_form__user_id_378bdf3e_fk_auth_user` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_form__form_code_id_350d3c3d_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`),
  CONSTRAINT `change_request_form__tmp_stake_id_fe1f7139_fk_change_re` FOREIGN KEY (`tmp_stake_id`) REFERENCES `change_request_template_stakeholders` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_form_stakeholders: ~0 rows (approximately)
DELETE FROM `change_request_form_stakeholders`;
/*!40000 ALTER TABLE `change_request_form_stakeholders` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_form_stakeholders` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_history
CREATE TABLE IF NOT EXISTS `change_request_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `action` varchar(50) NOT NULL,
  `entity` varchar(50) NOT NULL,
  `form_code` varchar(255) DEFAULT NULL,
  `fromValue` longtext,
  `toValue` longtext,
  `batch_no` varchar(255) DEFAULT NULL,
  `main_action` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_history: ~0 rows (approximately)
DELETE FROM `change_request_history`;
/*!40000 ALTER TABLE `change_request_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_history` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_approvers
CREATE TABLE IF NOT EXISTS `change_request_template_approvers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` varchar(50) DEFAULT NULL,
  `delegation` varchar(50) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `archived_at` datetime(6) DEFAULT NULL,
  `template_no_id` varchar(255) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_templ_template_no_id_fba2afd7_fk_change_re` (`template_no_id`),
  KEY `change_request_templ_user_id_958c925a_fk_auth_user` (`user_id`),
  CONSTRAINT `change_request_templ_user_id_958c925a_fk_auth_user` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_templ_template_no_id_fba2afd7_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_template_approvers: ~0 rows (approximately)
DELETE FROM `change_request_template_approvers`;
/*!40000 ALTER TABLE `change_request_template_approvers` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_template_approvers` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_attachments
CREATE TABLE IF NOT EXISTS `change_request_template_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_type` varchar(255) NOT NULL,
  `attachment_name` varchar(255) NOT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `file_upload` varchar(100) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `archived_at` datetime(6) DEFAULT NULL,
  `template_no_id` varchar(255) NOT NULL,
  `uploaded_by_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_templ_template_no_id_d0247a80_fk_change_re` (`template_no_id`),
  KEY `change_request_templ_uploaded_by_id_f9c6493a_fk_auth_user` (`uploaded_by_id`),
  CONSTRAINT `change_request_templ_uploaded_by_id_f9c6493a_fk_auth_user` FOREIGN KEY (`uploaded_by_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_templ_template_no_id_d0247a80_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_template_attachments: ~0 rows (approximately)
DELETE FROM `change_request_template_attachments`;
/*!40000 ALTER TABLE `change_request_template_attachments` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_template_attachments` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_details
CREATE TABLE IF NOT EXISTS `change_request_template_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_idx` longtext NOT NULL,
  `field_ref` longtext NOT NULL,
  `field_val` longtext NOT NULL,
  `field_props` longtext NOT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `archived_at` datetime(6) DEFAULT NULL,
  `template_no_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_templ_template_no_id_d2ba31c2_fk_change_re` (`template_no_id`),
  CONSTRAINT `change_request_templ_template_no_id_d2ba31c2_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_template_details: ~0 rows (approximately)
DELETE FROM `change_request_template_details`;
/*!40000 ALTER TABLE `change_request_template_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_template_details` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_headers
CREATE TABLE IF NOT EXISTS `change_request_template_headers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `requested_to_template_name` varchar(255) NOT NULL,
  `requested_to_objective` varchar(255) DEFAULT NULL,
  `requested_to_priority` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `template_no` varchar(255) NOT NULL,
  `requested_to_template_id` varchar(255) NOT NULL,
  `requested_to_target_date` varchar(10) DEFAULT NULL,
  `archived_at` datetime(6) DEFAULT NULL,
  `created_by_department_id` varchar(255) NOT NULL,
  `created_by_user_id` varchar(255) NOT NULL,
  `requested_to_company_id` varchar(255) NOT NULL,
  `requested_to_department_id` varchar(255) NOT NULL,
  `requested_to_user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `template_no` (`template_no`),
  UNIQUE KEY `requested_to_template_id` (`requested_to_template_id`),
  KEY `change_request_templ_created_by_departmen_f5629a3a_fk_departmen` (`created_by_department_id`),
  KEY `change_request_templ_created_by_user_id_ed6f2326_fk_auth_user` (`created_by_user_id`),
  KEY `change_request_templ_requested_to_company_1063b954_fk_companies` (`requested_to_company_id`),
  KEY `change_request_templ_requested_to_departm_e7b33c56_fk_departmen` (`requested_to_department_id`),
  KEY `change_request_templ_requested_to_user_id_cfad98f0_fk_auth_user` (`requested_to_user_id`),
  CONSTRAINT `change_request_templ_requested_to_user_id_cfad98f0_fk_auth_user` FOREIGN KEY (`requested_to_user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_templ_created_by_departmen_f5629a3a_fk_departmen` FOREIGN KEY (`created_by_department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `change_request_templ_created_by_user_id_ed6f2326_fk_auth_user` FOREIGN KEY (`created_by_user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_templ_requested_to_company_1063b954_fk_companies` FOREIGN KEY (`requested_to_company_id`) REFERENCES `companies` (`code`),
  CONSTRAINT `change_request_templ_requested_to_departm_e7b33c56_fk_departmen` FOREIGN KEY (`requested_to_department_id`) REFERENCES `departments` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_template_headers: ~0 rows (approximately)
DELETE FROM `change_request_template_headers`;
/*!40000 ALTER TABLE `change_request_template_headers` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_template_headers` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_stakeholders
CREATE TABLE IF NOT EXISTS `change_request_template_stakeholders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `delegation` varchar(255) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `archived_at` datetime(6) DEFAULT NULL,
  `template_no_id` varchar(255) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_templ_template_no_id_31bc8d14_fk_change_re` (`template_no_id`),
  KEY `change_request_templ_user_id_63128227_fk_auth_user` (`user_id`),
  CONSTRAINT `change_request_templ_user_id_63128227_fk_auth_user` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_templ_template_no_id_31bc8d14_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_template_stakeholders: ~0 rows (approximately)
DELETE FROM `change_request_template_stakeholders`;
/*!40000 ALTER TABLE `change_request_template_stakeholders` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_template_stakeholders` ENABLE KEYS */;

-- Dumping structure for table rms_db.companies
CREATE TABLE IF NOT EXISTS `companies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `contact_details` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.companies: ~2 rows (approximately)
DELETE FROM `companies`;
/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
INSERT INTO `companies` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`, `contact_details`) VALUES
	(1, '2019-09-23 12:45:31.058709', 'superuser', '2019-09-23 13:15:45.068355', 'superuser', 'COMPANY-20190923-0000001', 'Oneberry Technologies Pte Ltd.', '2152509'),
	(2, '2019-09-23 13:05:24.438314', 'superuser', '2019-09-23 13:05:24.438314', 'superuser', 'COMPANY-20190923-0000002', 'Total Integrated Resources', '2152509');
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;

-- Dumping structure for table rms_db.departments
CREATE TABLE IF NOT EXISTS `departments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `company_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`),
  KEY `departments_company_id_0d17e9ca_fk_companies_code` (`company_id`),
  CONSTRAINT `departments_company_id_0d17e9ca_fk_companies_code` FOREIGN KEY (`company_id`) REFERENCES `companies` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.departments: ~2 rows (approximately)
DELETE FROM `departments`;
/*!40000 ALTER TABLE `departments` DISABLE KEYS */;
INSERT INTO `departments` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`, `company_id`) VALUES
	(1, '2019-09-23 12:45:52.531178', 'superuser', '2019-09-23 12:45:52.531178', 'superuser', 'DEPARTMENT-20190923-0000001', 'ADMIN', 'COMPANY-20190923-0000001'),
	(2, '2019-09-23 13:05:01.811980', 'superuser', '2019-09-23 13:05:01.811980', 'superuser', 'DEPARTMENT-20190923-0000002', 'Business Develsopment', 'COMPANY-20190923-0000001');
/*!40000 ALTER TABLE `departments` ENABLE KEYS */;

-- Dumping structure for table rms_db.django_admin_log
CREATE TABLE IF NOT EXISTS `django_admin_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action_time` datetime(6) NOT NULL,
  `object_id` longtext,
  `object_repr` varchar(200) NOT NULL,
  `action_flag` smallint(5) unsigned NOT NULL,
  `change_message` longtext NOT NULL,
  `content_type_id` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `django_admin_log_content_type_id_c4bce8eb_fk_django_co` (`content_type_id`),
  KEY `django_admin_log_user_id_c564eba6_fk_auth_user_id` (`user_id`),
  CONSTRAINT `django_admin_log_user_id_c564eba6_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`),
  CONSTRAINT `django_admin_log_content_type_id_c4bce8eb_fk_django_co` FOREIGN KEY (`content_type_id`) REFERENCES `django_content_type` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.django_admin_log: ~0 rows (approximately)
DELETE FROM `django_admin_log`;
/*!40000 ALTER TABLE `django_admin_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `django_admin_log` ENABLE KEYS */;

-- Dumping structure for table rms_db.django_content_type
CREATE TABLE IF NOT EXISTS `django_content_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_label` varchar(100) NOT NULL,
  `model` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `django_content_type_app_label_model_76bd3d3b_uniq` (`app_label`,`model`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.django_content_type: ~34 rows (approximately)
DELETE FROM `django_content_type`;
/*!40000 ALTER TABLE `django_content_type` DISABLE KEYS */;
INSERT INTO `django_content_type` (`id`, `app_label`, `model`) VALUES
	(1, 'admin', 'logentry'),
	(3, 'auth', 'group'),
	(2, 'auth', 'permission'),
	(6, 'authtoken', 'token'),
	(4, 'contenttypes', 'contenttype'),
	(34, 'entities', 'allowedcompany'),
	(8, 'entities', 'application'),
	(9, 'entities', 'attachment'),
	(33, 'entities', 'authtoken'),
	(32, 'entities', 'changerequestformapprovers'),
	(31, 'entities', 'changerequestformattachments'),
	(30, 'entities', 'changerequestformdetails'),
	(10, 'entities', 'changerequestformheader'),
	(29, 'entities', 'changerequestformstakeholders'),
	(11, 'entities', 'changerequesthistory'),
	(28, 'entities', 'changerequesttemplateapprovers'),
	(27, 'entities', 'changerequesttemplateattachments'),
	(26, 'entities', 'changerequesttemplatedetails'),
	(12, 'entities', 'changerequesttemplateheader'),
	(25, 'entities', 'changerequesttemplatestakeholders'),
	(13, 'entities', 'company'),
	(24, 'entities', 'department'),
	(14, 'entities', 'emaillogs'),
	(15, 'entities', 'entitylog'),
	(23, 'entities', 'module'),
	(22, 'entities', 'notification'),
	(16, 'entities', 'passwordreset'),
	(17, 'entities', 'permission'),
	(18, 'entities', 'role'),
	(21, 'entities', 'rolepermission'),
	(19, 'entities', 'status'),
	(7, 'entities', 'user'),
	(20, 'entities', 'userimage'),
	(5, 'sessions', 'session');
/*!40000 ALTER TABLE `django_content_type` ENABLE KEYS */;

-- Dumping structure for table rms_db.django_migrations
CREATE TABLE IF NOT EXISTS `django_migrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `applied` datetime(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.django_migrations: ~25 rows (approximately)
DELETE FROM `django_migrations`;
/*!40000 ALTER TABLE `django_migrations` DISABLE KEYS */;
INSERT INTO `django_migrations` (`id`, `app`, `name`, `applied`) VALUES
	(1, 'contenttypes', '0001_initial', '2019-09-23 12:11:35.906573'),
	(2, 'contenttypes', '0002_remove_content_type_name', '2019-09-23 12:11:36.490409'),
	(3, 'auth', '0001_initial', '2019-09-23 12:11:37.058071'),
	(4, 'auth', '0002_alter_permission_name_max_length', '2019-09-23 12:11:39.862929'),
	(5, 'auth', '0003_alter_user_email_max_length', '2019-09-23 12:11:39.921932'),
	(6, 'auth', '0004_alter_user_username_opts', '2019-09-23 12:11:39.971932'),
	(7, 'auth', '0005_alter_user_last_login_null', '2019-09-23 12:11:40.007947'),
	(8, 'auth', '0006_require_contenttypes_0002', '2019-09-23 12:11:40.049915'),
	(9, 'auth', '0007_alter_validators_add_error_messages', '2019-09-23 12:11:40.114587'),
	(10, 'auth', '0008_alter_user_username_max_length', '2019-09-23 12:11:40.137629'),
	(11, 'auth', '0009_alter_user_last_name_max_length', '2019-09-23 12:11:40.191583'),
	(12, 'auth', '0010_alter_group_name_max_length', '2019-09-23 12:11:40.776954'),
	(13, 'auth', '0011_update_proxy_permissions', '2019-09-23 12:11:40.806005'),
	(14, 'entities', '0001_initial', '2019-09-23 12:11:47.314099'),
	(15, 'admin', '0001_initial', '2019-09-23 12:12:20.565456'),
	(16, 'admin', '0002_logentry_remove_auto_add', '2019-09-23 12:12:22.270994'),
	(17, 'admin', '0003_logentry_add_action_flag_choices', '2019-09-23 12:12:22.313993'),
	(18, 'authtoken', '0001_initial', '2019-09-23 12:12:22.724754'),
	(19, 'authtoken', '0002_auto_20160226_1747', '2019-09-23 12:12:24.556122'),
	(20, 'entities', '0002_auto_20190917_1716', '2019-09-23 12:12:27.836819'),
	(21, 'entities', '0003_allowedcompany', '2019-09-23 12:12:28.055013'),
	(22, 'entities', '0004_auto_20190918_1104', '2019-09-23 12:12:32.014816'),
	(23, 'entities', '0005_auto_20190919_1625', '2019-09-23 12:12:32.061785'),
	(24, 'entities', '0006_auto_20190920_1623', '2019-09-23 12:12:32.202029'),
	(25, 'sessions', '0001_initial', '2019-09-23 12:12:32.568139');
/*!40000 ALTER TABLE `django_migrations` ENABLE KEYS */;

-- Dumping structure for table rms_db.django_session
CREATE TABLE IF NOT EXISTS `django_session` (
  `session_key` varchar(40) NOT NULL,
  `session_data` longtext NOT NULL,
  `expire_date` datetime(6) NOT NULL,
  PRIMARY KEY (`session_key`),
  KEY `django_session_expire_date_a5c62663` (`expire_date`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.django_session: ~0 rows (approximately)
DELETE FROM `django_session`;
/*!40000 ALTER TABLE `django_session` DISABLE KEYS */;
INSERT INTO `django_session` (`session_key`, `session_data`, `expire_date`) VALUES
	('mc4vdpxrj9jb7rbqrb1chb50mgbqclc9', 'MzQxODFjZjQ3YWYwOTFkYjE0MjBkOTgwNTQ0YjE0MTE4MjU1ZWUzYzp7Il9hdXRoX3VzZXJfaWQiOiIxIiwiX2F1dGhfdXNlcl9iYWNrZW5kIjoiZGphbmdvLmNvbnRyaWIuYXV0aC5iYWNrZW5kcy5Nb2RlbEJhY2tlbmQiLCJfYXV0aF91c2VyX2hhc2giOiI5YzQyMzU3N2YyZTM5ODkyMTQ5Y2I4ZjdmY2NjZDA2ZjQwNDgzMGQxIn0=', '2019-10-07 15:50:43.928893');
/*!40000 ALTER TABLE `django_session` ENABLE KEYS */;

-- Dumping structure for table rms_db.email_logs
CREATE TABLE IF NOT EXISTS `email_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `template` varchar(255) NOT NULL,
  `recipients` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `is_sent` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.email_logs: ~0 rows (approximately)
DELETE FROM `email_logs`;
/*!40000 ALTER TABLE `email_logs` DISABLE KEYS */;
INSERT INTO `email_logs` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `template`, `recipients`, `content`, `is_sent`) VALUES
	(1, '2019-09-23 15:05:04.033912', 'red@tirsolutions.com', '2019-09-23 15:05:04.033972', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test@mail.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear test,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test<br><br>\n<b>Password</b><br>kMmCfLzPqH<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(2, '2019-09-23 15:11:18.289586', 'red@tirsolutions.com', '2019-09-23 15:11:18.289637', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test@mail.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear test,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test<br><br>\n<b>Password</b><br>JCYDkZJyEG<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(3, '2019-09-23 15:12:36.090854', 'red@tirsolutions.com', '2019-09-23 15:12:36.090925', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test@mail.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear test,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test<br><br>\n<b>Password</b><br>Ereu8p2j5B<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(4, '2019-09-23 15:13:23.932304', 'red@tirsolutions.com', '2019-09-23 15:13:23.932363', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test@test.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear test,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test<br><br>\n<b>Password</b><br>yKT6DnQEj8<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(5, '2019-09-23 15:14:45.654449', 'red@tirsolutions.com', '2019-09-23 15:14:45.654507', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'tesrt@test.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear test,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test<br><br>\n<b>Password</b><br>FwvseNbjVW<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(6, '2019-09-23 15:24:02.628865', 'red@tirsolutions.com', '2019-09-23 15:24:02.628939', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'asdf@asdf.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear sadf,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>asdf<br><br>\n<b>Password</b><br>2VG2h6xWqs<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(7, '2019-09-23 15:51:49.987044', 'red@tirsolutions.com', '2019-09-23 15:51:49.987101', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test22@mailc.om', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear test,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>Test<br><br>\n<b>Password</b><br>xNC4n7QpbR<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(8, '2019-09-23 15:55:16.013625', 'red@tirsolutions.com', '2019-09-23 15:55:16.013681', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test@mail.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear test,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test<br><br>\n<b>Password</b><br>wxmTN876hE<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(9, '2019-09-23 16:06:34.050967', 'red@tirsolutions.com', '2019-09-23 16:06:34.051025', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'qwe@qwe.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear qwe,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>qwe<br><br>\n<b>Password</b><br>qwAMrgpfTJ<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1);
/*!40000 ALTER TABLE `email_logs` ENABLE KEYS */;

-- Dumping structure for table rms_db.entity_logs
CREATE TABLE IF NOT EXISTS `entity_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `action` varchar(50) NOT NULL,
  `entity` varchar(50) NOT NULL,
  `row_id` int(11) NOT NULL,
  `fromValue` longtext,
  `toValue` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.entity_logs: ~9 rows (approximately)
DELETE FROM `entity_logs`;
/*!40000 ALTER TABLE `entity_logs` DISABLE KEYS */;
INSERT INTO `entity_logs` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `action`, `entity`, `row_id`, `fromValue`, `toValue`) VALUES
	(1, '2019-09-23 12:48:05.931814', 'superuser', '2019-09-23 12:48:05.931814', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T12:48:05.929814\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'TIR2\', \'contact_details\': \'2152509\'}'),
	(2, '2019-09-23 12:48:11.310096', 'superuser', '2019-09-23 12:48:11.310096', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'TIR2\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T12:48:11.274128\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry\', \'contact_details\': \'2152509\'}'),
	(3, '2019-09-23 12:49:56.778639', 'superuser', '2019-09-23 12:49:56.778639', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T12:49:56.777634\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry\', \'contact_details\': \'2152509\'}'),
	(4, '2019-09-23 12:50:02.263275', 'superuser', '2019-09-23 12:50:02.263275', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T12:50:02.227274\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry2\', \'contact_details\': \'2152509\'}'),
	(5, '2019-09-23 12:50:55.877339', 'superuser', '2019-09-23 12:50:55.877339', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry2\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T12:50:55.875341\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry\', \'contact_details\': \'2152509\'}'),
	(6, '2019-09-23 13:05:43.563853', 'superuser', '2019-09-23 13:05:43.563853', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T13:05:43.518888\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies\', \'contact_details\': \'2152509\'}'),
	(7, '2019-09-23 13:09:22.477286', 'superuser', '2019-09-23 13:09:22.477286', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T13:09:22.475282\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd\', \'contact_details\': \'2152509\'}'),
	(8, '2019-09-23 13:09:24.850090', 'superuser', '2019-09-23 13:09:24.850090', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T13:09:24.847086\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd\', \'contact_details\': \'2152509\'}'),
	(9, '2019-09-23 13:15:45.071569', 'superuser', '2019-09-23 13:15:45.071605', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T13:15:45.068355\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}'),
	(10, '2019-09-23 15:10:51.623935', 'superuser', '2019-09-23 15:10:51.623987', 'superuser', 'DELETED', 'USER', 2, '{\'id\': 2, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 15, 5, 1, 454792), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190923-0000002\', \'name\': \'test\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$z057AgrJd6Dz$SgQVEjk1GrFaT4sCZXFtmcoN3q0v7/ONUQm+y2hyobk=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'test@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', ''),
	(11, '2019-09-23 15:12:06.586604', 'superuser', '2019-09-23 15:12:06.586654', 'superuser', 'DELETED', 'USER', 3, '{\'id\': 3, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 15, 11, 15, 641547), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190923-0000003\', \'name\': \'test\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$2SMJgpQ4YiB6$hpSJMse3ngMOPOaaFZ+e8f+gkVxAPcLBLkzeoQd0UPI=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'test@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', ''),
	(12, '2019-09-23 15:12:54.914735', 'superuser', '2019-09-23 15:12:54.914785', 'superuser', 'DELETED', 'USER', 4, '{\'id\': 4, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 15, 12, 33, 578673), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190923-0000004\', \'name\': \'test\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$4Ck5OflLBUuy$mppNvyH7jOZ6h05yRKT2TqiHmzqr5VgsTu2Svj90BQk=\', \'doa\': None, \'contact_no\': \'132\', \'email\': \'test@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', ''),
	(13, '2019-09-23 15:14:08.458030', 'superuser', '2019-09-23 15:14:08.458079', 'superuser', 'DELETED', 'USER', 5, '{\'id\': 5, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 15, 13, 21, 401634), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000005\', \'name\': \'test\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$oZIwTtIDXNa0$6p5/TFknXP23DECJMGj6HvE/X2+oLncL3MdwuE6H1q4=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'test@test.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(14, '2019-09-23 15:21:13.695716', 'superuser', '2019-09-23 15:21:13.695764', 'superuser', 'DELETED', 'USER', 6, '{\'id\': 6, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 15, 14, 43, 77542), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000006\', \'name\': \'test\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$EW2EIPV0Fuo5$EADUUoNj2X7Tn7TCbx6oHqrJTVuIEB6gz7xfOhXun/o=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'tesrt@test.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(15, '2019-09-23 15:54:36.556122', 'superuser', '2019-09-23 15:54:36.556171', 'superuser', 'DELETED', 'USER', 8, '{\'id\': 8, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 15, 51, 47, 458185), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000008\', \'name\': \'test\', \'username\': \'Test\', \'password\': \'pbkdf2_sha256$150000$GepNh7zbymGQ$h+/dpjxOxOfvQUOAvivFh7U/vbpZlAk1qG+EFtylDf0=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'test22@mailc.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(16, '2019-09-23 15:54:40.072773', 'superuser', '2019-09-23 15:54:40.072822', 'superuser', 'DELETED', 'USER', 7, '{\'id\': 7, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 15, 24, 0, 159173), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000007\', \'name\': \'sadf\', \'username\': \'asdf\', \'password\': \'pbkdf2_sha256$150000$lt8dSuAs79lJ$hmMk+LyoFQzdBFtv4e36KEdN/a+UChOU/cTgqs5g9Ws=\', \'doa\': None, \'contact_no\': \'132\', \'email\': \'asdf@asdf.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '');
/*!40000 ALTER TABLE `entity_logs` ENABLE KEYS */;

-- Dumping structure for table rms_db.modules
CREATE TABLE IF NOT EXISTS `modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `parent` int(11) DEFAULT NULL,
  `sort_id` int(11) NOT NULL,
  `component` varchar(255) DEFAULT NULL,
  `application_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`),
  KEY `modules_application_id_f285bf5b_fk_applications_code` (`application_id`),
  CONSTRAINT `modules_application_id_f285bf5b_fk_applications_code` FOREIGN KEY (`application_id`) REFERENCES `applications` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.modules: ~8 rows (approximately)
DELETE FROM `modules`;
/*!40000 ALTER TABLE `modules` DISABLE KEYS */;
INSERT INTO `modules` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`, `parent`, `sort_id`, `component`, `application_id`) VALUES
	(1, '2019-09-23 12:46:12.211187', 'superuser', '2019-09-23 12:46:12.211187', 'superuser', 'MODULE-20190923-0000001', 'RMS HEADER', 0, 8, NULL, 'APP-20190923-0000001'),
	(2, '2019-09-23 12:46:31.481209', 'superuser', '2019-09-23 12:46:31.481209', 'superuser', 'MODULE-20190923-0000002', 'Application Management', 1, 1, 'rms/application-management', 'APP-20190923-0000001'),
	(3, '2019-09-23 12:46:48.031401', 'superuser', '2019-09-23 12:46:48.031401', 'superuser', 'MODULE-20190923-0000003', 'Company Management', 1, 2, 'rms/company-management', 'APP-20190923-0000001'),
	(4, '2019-09-23 12:46:52.207690', 'superuser', '2019-09-23 12:46:52.207690', 'superuser', 'MODULE-20190923-0000004', 'Department Management', 1, 3, 'rms/department-management', 'APP-20190923-0000001'),
	(5, '2019-09-23 12:46:57.033689', 'superuser', '2019-09-23 12:46:57.033689', 'superuser', 'MODULE-20190923-0000005', 'Module Management', 1, 4, 'rms/module-management', 'APP-20190923-0000001'),
	(6, '2019-09-23 12:47:02.615922', 'superuser', '2019-09-23 12:47:02.615922', 'superuser', 'MODULE-20190923-0000006', 'User Management', 1, 5, 'rms/user-management', 'APP-20190923-0000001'),
	(7, '2019-09-23 13:02:59.128530', 'superuser', '2019-09-23 13:02:59.128530', 'superuser', 'MODULE-20190923-0000007', 'CMS HEADER', 0, 2, NULL, 'APP-20190923-0000002'),
	(8, '2019-09-23 13:10:14.026641', 'superuser', '2019-09-23 13:10:14.026641', 'superuser', 'MODULE-20190923-0000008', 'AMS HEADER', 0, 1, NULL, 'APP-20190923-0000003'),
	(9, '2019-09-23 14:25:25.469618', 'superuser', '2019-09-23 14:25:25.469668', 'superuser', 'MODULE-20190923-0000009', 'Change Request Template', 7, 1, 'cms/change-request/template/', 'APP-20190923-0000002');
/*!40000 ALTER TABLE `modules` ENABLE KEYS */;

-- Dumping structure for table rms_db.notifications
CREATE TABLE IF NOT EXISTS `notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `notif_type` varchar(20) NOT NULL,
  `message` varchar(255) DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `account_no` varchar(255) DEFAULT NULL,
  `app` varchar(255) DEFAULT NULL,
  `form_code` varchar(255) DEFAULT NULL,
  `sender_account_no` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.notifications: ~0 rows (approximately)
DELETE FROM `notifications`;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;

-- Dumping structure for table rms_db.password_resets
CREATE TABLE IF NOT EXISTS `password_resets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` datetime(6) NOT NULL,
  `timeout_at` datetime(6) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `code` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.password_resets: ~0 rows (approximately)
DELETE FROM `password_resets`;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;

-- Dumping structure for table rms_db.permissions
CREATE TABLE IF NOT EXISTS `permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.permissions: ~0 rows (approximately)
DELETE FROM `permissions`;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.roles
CREATE TABLE IF NOT EXISTS `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.roles: ~0 rows (approximately)
DELETE FROM `roles`;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;

-- Dumping structure for table rms_db.role_permissions
CREATE TABLE IF NOT EXISTS `role_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `permission_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `role_permissions_permission_id_ad343843_fk_permissions_id` (`permission_id`),
  KEY `role_permissions_role_id_216516f2_fk_roles_id` (`role_id`),
  CONSTRAINT `role_permissions_role_id_216516f2_fk_roles_id` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`),
  CONSTRAINT `role_permissions_permission_id_ad343843_fk_permissions_id` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.role_permissions: ~0 rows (approximately)
DELETE FROM `role_permissions`;
/*!40000 ALTER TABLE `role_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.status_set
CREATE TABLE IF NOT EXISTS `status_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `ref` varchar(10) NOT NULL,
  `code` varchar(10) NOT NULL,
  `name` varchar(10) NOT NULL,
  `description` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.status_set: ~0 rows (approximately)
DELETE FROM `status_set`;
/*!40000 ALTER TABLE `status_set` DISABLE KEYS */;
/*!40000 ALTER TABLE `status_set` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
